SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'APPLICANT_APPOINTMENT_PARENT_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'APPLICANT_APPOINTMENT_PARENT_RECIPIENT', 'SQL');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_APPOINTMENT_PARENT_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'APPLICANT_APPOINTMENT_PARENT_RECIPIENT');


SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='APPLICANT_APPOINTMENT');
SET @sysmsgevtdefaultconfId = (select id from `sys_msg_evt_default_conf` where `systemMsgEventId` = @sysMsgEventId);
SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_APPOINTMENT_PARENT_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='APPLICANT_APPOINTMENT_PARENT_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId, @dtproviderId, NULL, @recipientTypeId);



-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_APPOINTMENT_PARENT_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    T1.id AS USER_ID
FROM
    sg_appointment T1
        INNER JOIN
    sg_visit_status T2 ON T2.id = T1.visitStatusId
        INNER JOIN
    sg_visitor_category T3 ON T3.id = T1.visitorCategoryId
WHERE
    T1.id IN (namedParams)
        AND T2.itemCode = 'Completed'
        AND T3.id = 5",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_APPOINTMENT_PARENT_RECIPIENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    sg.id AS ID,
    T1.code AS APPLICANT_CODE,
    T2.firstName AS STUDENT_FIRST_NAME,
    T2.lastName AS STUDENT_LAST_NAME,
    T4.displayName AS ACADEMY_NAME_LOCATION,    
    T4.academyName AS ACADEMY_NAME,
    T11.`emailId` AS EMAIL_ID,
    T11.`mobileNumber` AS MOBILE_NO,
    T11.`mobileCountryCode` AS MOBILE_CODE,
    T11.`firstName` AS FIRST_NAME,
    T11.`lastName` AS LAST_NAME,
    CONCAT(T6.phoneCountryCode,'-',T6.phoneAreaCode,'-',T6.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
    T6.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
    T6.websiteURL AS ACADEMY_LOCATION_URL,
    (Case when T4.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T4.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T4.logoUrl)end) as LOGO_URL,
    (Case when T4.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.headerUrl) 
    else NULL end) as HEADER_URL,
    (Case when T4.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.footerUrl)
    else NULL end) as FOOTER_URL
FROM
    sg_appointment sg
        INNER JOIN
    application T1 ON T1.id = sg.applicationId
        LEFT JOIN
    applicant_person T2 ON T2.id = T1.applicantPersonId
        LEFT OUTER JOIN
    applicant_person_relationships T3 ON T3.applicantPersonId = T2.id
        LEFT JOIN
    applicant_person T11 ON T11.id = T3.relatedApplicantPersonId
        LEFT JOIN
    academy_location T4 ON T4.id = T1.issuedFromAcademyLocation
        LEFT JOIN
    academy_location_addresses T5 ON T5.academyLocationId = T4.id
        LEFT JOIN
    address T6 ON T6.id = T5.addressId AND T6.addressTypeId = 10
        LEFT JOIN
    organizations org on org.id = 1
WHERE
    sg.id IN (namedParams)",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "APPLICANT_CODE",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "studentFirstName",
            "resultKey": "STUDENT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "studentLastName",
            "resultKey": "STUDENT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 3
        },       
        {
            "id": 5,
            "value": "academyLocationEmailId",
            "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "academyLocationPhoneNo",
            "resultKey": "ACADEMY_LOCATION_PHONE_NO",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "academyLocationURL",
            "resultKey": "ACADEMY_LOCATION_URL",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 9
        }
    ]
}');


SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='APPLICANT_APPOINTMENT');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='APPOINTMENT');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='APPLICANT_APPOINTMENT_PARENT_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');


INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'Appointment Completion Parents - Application',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Appointment Completion Parents - Application',NULL,'',NULL,'','APPROVED','','1','System Admin','1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','APPOINTMENT COMPLETED','<html>
<head>
    <title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
    <tbody>
    <tr style="background-color:#f0f0f0; height:120px;">
            <td align="center" style="margin:0px;"><img height="120" src="$recipientData[&quot;HEADER_URL&quot;]" width="100%" /></td>
        </tr>
        <tr style="background-color:#f0f0f0; line-height:20px;">
            <td style="padding:20px 20px 20px 20px;">
            
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear <strong>$recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;]</strong>, please note that <strong>$recipientData[&quot;APPLICANT_CODE&quot;]</strong> has completed an appointment with us. The next step is application. Applications can be completed at <strong>$recipientData[&quot;ACADEMY_LOCATION_URL&quot;]</strong></span></span>.</p>

            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">If you have any questions, please contact us on <strong>$recipientData[&quot;ACADEMY_LOCATION_PHONE_NO&quot;]</strong> or <strong>$recipientData[&quot;ACADEMY_LOCATION_EMAIL_ID&quot;]</strong>, alternatively visit our website <strong>$recipientData[&quot;ACADEMY_LOCATION_URL&quot;]</strong>.</p>
          
           <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"><br/>
Kind regards, <br/><br/>
<strong>$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</strong><br/>
$recipientData[&quot;ACADEMY_LOCATION_EMAIL_ID&quot;]<br/>
$recipientData[&quot;ACADEMY_LOCATION_PHONE_NO&quot;]<br/>
$recipientData[&quot;ACADEMY_LOCATION_URL&quot;]</span></span></p>
            </td>
        </tr>
        <tr>
            <td align="right" style="background-color: #f0f0f0; margin:0px; padding:25px"><img height="50" src="$recipientData[&quot;LOGO_URL&quot;]" /></td>
        </tr>
        <tr>
            <td align="center" style="margin:0px; padding:0px;"><img height="80" src="$recipientData[&quot;FOOTER_URL&quot;]" width="100%" /></td>
        </tr>
    </tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'2',NULL,'Dear $recipientData["FIRST_NAME"] $recipientData["LAST_NAME"], please note that $recipientData["APPLICANT_CODE"] has completed an appointment with us. The next step is application. Applications can be completed at $recipientData["ACADEMY_LOCATION_URL"]. If you have any questions, please contact us using the details below. Kind regards, $recipientData[&quot;ACADEMY_NAME_LOCATION&quot;], $recipientData[&quot;ACADEMY_LOCATION_EMAIL_ID&quot;], $recipientData[&quot;ACADEMY_LOCATION_PHONE_NO&quot;], $recipientData[&quot;ACADEMY_LOCATION_URL&quot;]'); 